//Experiment-1
// windows 8.1 - 64-Bit
//Scilab - 6.0.0

//Aim : Air gap MMF calculation for magnetic circuits using SCILAB
// Data: Calculate mmf required for the air gap of dc achine having open slots

clc
clear all

// Following data are to be taken from user 

ys=input('Enter Value of slot pitch in cm') // slot pitch of DC machine ( in range of 4 - 6 cm)
yo=input('Enter Value of slot opening in cm') // slot opening in DC machine ( in range of 2 - 4 cm)
L=input('Enter Value of gross core length in cm') // length of armature core ( in range of 40 70 cm)
psi=input('Enter Value of pole arc in cm') // pole arc value in DC machine ( in range of 15 3 25 cm)
lg=input('Enter Value of airgap length in cm') // length of airgap between armature and stator in DC machine ( in range of 0.4 - 0.7 cm)
phi=input('Enter Value of flux per pole in Wb') // airgap flux ( in range of 0.04 - 0.08 Wb)
nd=input('Enter no. of ventilating ducts') // radial ventilating ducts ( in range of 4 - 10 ducts)
bd=input('Enter opening of each ventilating duct') // duct opening ( in range of 1 - 1.5 cm)
 
 // Actual calculations begin
 
slot_ratio = yo/lg
if slot_ratio <= 1 then
kcs = 0.15 // carter's coefficient for slots    
elseif slot_ratio <= 2 then
    kcs = 0.28 // carter's coefficient for slots    
elseif slot_ratio <= 3 then
    kcs = 0.37 // carter's coefficient for slots    
elseif slot_ratio <= 3.6 then
    kcs = 0.41 // carter's coefficient for slots    
else
    kcs = 0.43 // carter's coefficient for slots    
end

duct_ratio = bd/lg
if duct_ratio <= 1 then
kcd = 0.15 // carter's coefficient for ducts    
elseif duct_ratio <= 2 then
kcd = 0.28 // carter's coefficient for ducts    
elseif duct_ratio <= 3 then
kcd = 0.37 // carter's coefficient for ducts    
elseif duct_ratio <= 3.5 then
kcd = 0.41 // carter's coefficient for ducts    
else
    kcd = 0.43 // carter's coefficient for ducts
end

kgs = (ys)/(ys-kcs*yo) // gap contraction factor for slots
kgd = (L)/(L-kcd*nd*bd) // gap contraction factor for ducts
Bg  = (phi*1e4)/(psi*L) // air gap flux density
ATg = 8e3*Bg*kgs*kgd*lg

mprintf('MMF for air gap is %d AT',ATg)
